/**
* \file: GstreamerVideoOut.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: Veeraiyan Chidambaram /RBEI/ECF3/ veeraiyan.chidambaram@in.bosch.com
*          J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_GSTREAMERVIDEOOUT_H
#define CARPLAY_GSTREAMERVIDEOOUT_H

#include <atomic>
#include <carplay_plugin.h>

#define VIDEO_OUT_TIMEOUT		500000000LL

// forward declarations
struct _GstElement;
typedef struct _GstElement GstElement;
struct _GValue;
typedef struct _GValue GValue;
typedef unsigned long int pthread_t;

namespace adit { namespace carplay
{

class GstreamerCommon;

class GstreamerVideoOut : public IVideoOutAdapter
{
public :
    GstreamerVideoOut();
    virtual ~GstreamerVideoOut();

    // IVideoOutAdapter implementation
    // no thread-safety required
public:
    virtual bool Initialize(const IConfiguration& inConfig, int inWidth, int inHeight,
            Framerate inFramerate,IVideoReceiver &inReceiver, SessionId inSessionId);
    virtual bool Start();
    virtual void Stop();
    virtual void Push(FrameFragment& inFragment);

    // private section
private:
    IVideoReceiver *receiver;
    const IConfiguration* config;
    SessionId sessionId;

    GstreamerCommon* common;

    GstElement* appsrc;
    GstElement* videosink;
    unsigned long enoughDataHandlerId;
    unsigned long videoPlaybackStartHandlerId;

    int width;
    int height;
    Framerate framerate;

    std::atomic_bool running;

    std::string wlHandleName;
    struct wl_display* display;

    bool firstFrame;
    bool renderedfirstframe;
    uint64_t prepareTimeStamp;

    static void enoughDataHandler(GstElement* inPipeline, GstreamerVideoOut* inMe);
    static void videoPlaybackStartHandler(GstElement* inPipeline, GstPad* pad, GstreamerVideoOut* inMe);
    bool PrepareAndWaitForPushing();
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_GSTREAMERVIDEOOUT_H */
